/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.googleanalytics.tracking;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.vaadin.googleanalytics.tracking.EnableGoogleAnalytics;

public class TrackerConfiguration {
    public static final String DEFAULT_COOKIE_DOMAIN = "auto";
    private String trackingId;
    private String cookieDomain = "auto";
    private String pageViewPrefix = "";
    private String scriptUrl = "https://www.google-analytics.com/analytics.js";
    private final Map<String, Serializable> gaDebug = new LinkedHashMap<String, Serializable>();
    private final Map<String, Serializable> createParameters = new LinkedHashMap<String, Serializable>();
    private final Map<String, Serializable> initialValues = new LinkedHashMap<String, Serializable>();

    private TrackerConfiguration() {
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public TrackerConfiguration setTrackingId(String trackingId) {
        if (trackingId == null || trackingId.trim().isEmpty()) {
            throw new IllegalArgumentException("Tracking id must be defined");
        }
        this.trackingId = trackingId;
        return this;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public TrackerConfiguration setCookieDomain(String cookieDomain) {
        this.cookieDomain = Objects.requireNonNull(cookieDomain);
        return this;
    }

    public TrackerConfiguration setPageViewPrefix(String pageViewPrefix) {
        this.pageViewPrefix = Objects.requireNonNull(pageViewPrefix);
        return this;
    }

    public String getPageViewPrefix() {
        return this.pageViewPrefix;
    }

    public TrackerConfiguration setScriptUrl(String scriptUrl) {
        this.scriptUrl = Objects.requireNonNull(scriptUrl);
        return this;
    }

    public String getScriptUrl() {
        return this.scriptUrl;
    }

    public TrackerConfiguration setCreateField(String name, Serializable value) {
        this.createParameters.put(Objects.requireNonNull(name), value);
        return this;
    }

    public TrackerConfiguration removeCreateField(String name) {
        this.createParameters.remove(Objects.requireNonNull(name));
        return this;
    }

    public TrackerConfiguration setInitialValue(String name, Serializable value) {
        this.initialValues.put(Objects.requireNonNull(name), value);
        return this;
    }

    public TrackerConfiguration removeInitialValue(String name) {
        this.initialValues.remove(Objects.requireNonNull(name));
        return this;
    }

    public TrackerConfiguration setGaDebug(String name, Serializable value) {
        this.gaDebug.put(Objects.requireNonNull(name), value);
        return this;
    }

    public TrackerConfiguration removeGaDebug(String name) {
        this.gaDebug.remove(Objects.requireNonNull(name));
        return this;
    }

    public Map<String, Serializable> getCreateFields() {
        return Collections.unmodifiableMap(this.createParameters);
    }

    public Map<String, Serializable> getInitialValues() {
        return Collections.unmodifiableMap(this.initialValues);
    }

    public Map<String, Serializable> getGaDebug() {
        return Collections.unmodifiableMap(this.gaDebug);
    }

    public static TrackerConfiguration create(EnableGoogleAnalytics.LogLevel logLevel, boolean sendHits) {
        TrackerConfiguration config = new TrackerConfiguration();
        logLevel.apply(config);
        if (!sendHits) {
            config.setInitialValue("sendHitTask", null);
        }
        return config;
    }

    public static TrackerConfiguration fromAnnotation(EnableGoogleAnalytics annotation, boolean productionMode) {
        EnableGoogleAnalytics.LogLevel logLevel = productionMode ? annotation.productionLogging() : annotation.devLogging();
        boolean shouldSend = annotation.sendMode().shouldSend(productionMode);
        TrackerConfiguration config = TrackerConfiguration.create(logLevel, shouldSend);
        config.setTrackingId(annotation.value());
        config.setCookieDomain(annotation.cookieDomain());
        config.setPageViewPrefix(annotation.pageviewPrefix());
        return config;
    }
}

