/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.googleanalytics.tracking;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinServiceInitListener;
import java.io.Serializable;
import java.util.List;
import org.vaadin.googleanalytics.tracking.EnableGoogleAnalytics;
import org.vaadin.googleanalytics.tracking.GoogleAnalyticsTracker;
import org.vaadin.googleanalytics.tracking.IgnorePageView;
import org.vaadin.googleanalytics.tracking.TrackerConfigurator;

public class InitListener
implements VaadinServiceInitListener {
    public void serviceInit(ServiceInitEvent event) {
        event.getSource().addUIInitListener((UIInitListener & Serializable)uiInit -> {
            UI ui = uiInit.getUI();
            ui.addAfterNavigationListener((AfterNavigationListener & Serializable)navigationEvent -> {
                GoogleAnalyticsTracker tracker = GoogleAnalyticsTracker.get(ui);
                if (InitListener.shouldTrack(tracker, navigationEvent)) {
                    tracker.sendPageView(navigationEvent.getLocation().getPathWithQueryParameters());
                }
            });
        });
    }

    private static boolean shouldTrack(GoogleAnalyticsTracker tracker, AfterNavigationEvent navigationEvent) {
        if (InitListener.hasIgnore(navigationEvent)) {
            return false;
        }
        return tracker.isInitialized() || InitListener.canInitialize(navigationEvent);
    }

    private static boolean canInitialize(AfterNavigationEvent navigationEvent) {
        List routerChain = navigationEvent.getActiveChain();
        if (routerChain.isEmpty()) {
            return false;
        }
        Class<? extends HasElement> rootLayoutClass = InitListener.getRootLayout(routerChain);
        return rootLayoutClass.getAnnotation(EnableGoogleAnalytics.class) != null || TrackerConfigurator.class.isAssignableFrom(rootLayoutClass);
    }

    private static Class<? extends HasElement> getRootLayout(List<HasElement> routerChain) {
        return routerChain.get(routerChain.size() - 1).getClass();
    }

    private static boolean hasIgnore(AfterNavigationEvent navigationEvent) {
        return navigationEvent.getActiveChain().stream().anyMatch(InitListener::hasIgnoreAnnotation);
    }

    private static boolean hasIgnoreAnnotation(HasElement target) {
        return target.getClass().getAnnotation(IgnorePageView.class) != null;
    }
}

