/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.googleanalytics.tracking;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonCodec;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.shared.ui.LoadMode;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.vaadin.googleanalytics.tracking.EnableGoogleAnalytics;
import org.vaadin.googleanalytics.tracking.TrackerConfiguration;
import org.vaadin.googleanalytics.tracking.TrackerConfigurator;

public class GoogleAnalyticsTracker {
    private final UI ui;
    private boolean inited = false;
    private String pageViewPrefix = "";
    private ArrayList<Serializable[]> pendingActions = new ArrayList();

    private GoogleAnalyticsTracker(UI ui) {
        this.ui = ui;
    }

    public static GoogleAnalyticsTracker getCurrent() {
        UI ui = UI.getCurrent();
        if (ui == null) {
            return null;
        }
        return GoogleAnalyticsTracker.get(ui);
    }

    public static GoogleAnalyticsTracker get(UI ui) {
        GoogleAnalyticsTracker tracker = (GoogleAnalyticsTracker)ComponentUtil.getData((Component)ui, GoogleAnalyticsTracker.class);
        if (tracker == null) {
            tracker = new GoogleAnalyticsTracker(ui);
            ComponentUtil.setData((Component)ui, GoogleAnalyticsTracker.class, (Object)tracker);
        }
        return tracker;
    }

    private void init() {
        TrackerConfiguration config = GoogleAnalyticsTracker.createConfig(this.ui);
        if (config == null) {
            throw new IllegalStateException("There are pending actions for a tracker that isn't initialized and cannot be initialized automatically. Ensure there is a @" + EnableGoogleAnalytics.class.getSimpleName() + " on the application's main layout or that it implements " + TrackerConfigurator.class.getSimpleName() + ".");
        }
        String trackingId = config.getTrackingId();
        if (trackingId == null || trackingId.isEmpty()) {
            throw new IllegalStateException("No tracking id has been defined.");
        }
        this.pageViewPrefix = config.getPageViewPrefix();
        this.ui.getPage().executeJavaScript("window.ga=window.ga||function(){(ga.q=ga.q||[]).push(arguments)};ga.l=+new Date;", new Serializable[0]);
        Map<String, Serializable> gaDebug = config.getGaDebug();
        if (!gaDebug.isEmpty()) {
            this.ui.getPage().executeJavaScript("window.ga_debug = $0;", new Serializable[]{GoogleAnalyticsTracker.toJsonObject(gaDebug)});
        }
        this.sendAction(GoogleAnalyticsTracker.createAction("create", config.getCreateFields(), new Serializable[]{trackingId, config.getCookieDomain()}));
        Map<String, Serializable> initialValues = config.getInitialValues();
        if (!initialValues.isEmpty()) {
            this.sendAction(GoogleAnalyticsTracker.createAction("set", initialValues, new Serializable[0]));
        }
        this.ui.getPage().addJavaScript(config.getScriptUrl(), LoadMode.LAZY);
        this.inited = true;
    }

    private static TrackerConfiguration createConfig(UI ui) {
        TrackerConfiguration config = null;
        HasElement routeLayout = GoogleAnalyticsTracker.findRouteLayout(ui);
        boolean productionMode = ui.getSession().getConfiguration().isProductionMode();
        EnableGoogleAnalytics annotation = routeLayout.getClass().getAnnotation(EnableGoogleAnalytics.class);
        if (annotation != null) {
            config = TrackerConfiguration.fromAnnotation(annotation, productionMode);
        }
        if (routeLayout instanceof TrackerConfigurator) {
            if (config == null) {
                EnableGoogleAnalytics.LogLevel logLevel = productionMode ? EnableGoogleAnalytics.LogLevel.NONE : EnableGoogleAnalytics.LogLevel.DEBUG;
                boolean sendHits = EnableGoogleAnalytics.SendMode.PRODUCTION.shouldSend(productionMode);
                config = TrackerConfiguration.create(logLevel, sendHits);
            }
            ((TrackerConfigurator)routeLayout).configureTracker(config);
        }
        return config;
    }

    private static HasElement findRouteLayout(UI ui) {
        List routeChain = ui.getInternals().getActiveRouterTargetsChain();
        if (routeChain.isEmpty()) {
            throw new IllegalStateException("Cannot initialize when no router target is active");
        }
        return (HasElement)routeChain.get(routeChain.size() - 1);
    }

    private void sendAction(Serializable[] action) {
        if (!this.pageViewPrefix.isEmpty() && action.length == 3 && "set".equals(action[0]) && "page".equals(action[1])) {
            action[2] = this.pageViewPrefix + action[2];
        }
        this.ui.getPage().executeJavaScript("ga.apply(null, arguments)", action);
    }

    private static Serializable[] createAction(String command, Map<String, ? extends Serializable> fieldsObject, Serializable ... fields) {
        if (fields == null) {
            fields = new Serializable[]{null};
        }
        Stream<Serializable> argsStream = Stream.concat(Stream.of(command), Stream.of(fields));
        if (fieldsObject != null && !fieldsObject.isEmpty()) {
            argsStream = Stream.concat(argsStream, Stream.of(GoogleAnalyticsTracker.toJsonObject(fieldsObject)));
        }
        return (Serializable[])argsStream.toArray(Serializable[]::new);
    }

    private static JsonObject toJsonObject(Map<String, ? extends Serializable> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        return JsonUtils.createObject(map, JsonCodec::encodeWithoutTypeInfo);
    }

    public void ga(String command, Map<String, ? extends Serializable> fieldsObject, Serializable ... fields) {
        if (this.pendingActions.isEmpty()) {
            this.ui.beforeClientResponse((Component)this.ui, (SerializableConsumer & Serializable)context -> {
                if (!this.inited) {
                    this.init();
                }
                this.pendingActions.forEach(this::sendAction);
                this.pendingActions.clear();
            });
        }
        this.pendingActions.add(GoogleAnalyticsTracker.createAction(command, fieldsObject, fields));
    }

    public void sendPageView(String location) {
        this.sendPageView(location, null);
    }

    public void sendPageView(String location, Map<String, Serializable> fieldsObject) {
        this.ga("set", null, new Serializable[]{"page", location});
        this.ga("send", fieldsObject, new Serializable[]{"pageview"});
    }

    public void sendEvent(String category, String action) {
        this.ga("send", null, new Serializable[]{"event", category, action});
    }

    public void sendEvent(String category, String action, String label) {
        this.ga("send", null, new Serializable[]{"event", category, action, label});
    }

    public void sendEvent(String category, String action, String label, int value) {
        this.ga("send", null, new Serializable[]{"event", category, action, label, Integer.valueOf(value)});
    }

    public void sendEvent(String category, String action, Map<String, Serializable> fieldsObject) {
        this.ga("send", fieldsObject, new Serializable[]{"event", category, action});
    }

    public boolean isInitialized() {
        return this.inited;
    }
}

