/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.googleanalytics.tracking;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.vaadin.googleanalytics.tracking.TrackerConfiguration;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface EnableGoogleAnalytics {
    public String value();

    public String cookieDomain() default "auto";

    public LogLevel productionLogging() default LogLevel.NONE;

    public LogLevel devLogging() default LogLevel.DEBUG;

    public SendMode sendMode() default SendMode.PRODUCTION;

    public String pageviewPrefix() default "";

    public static enum SendMode {
        ALWAYS{

            @Override
            public boolean shouldSend(boolean productionMode) {
                return true;
            }
        }
        ,
        PRODUCTION{

            @Override
            public boolean shouldSend(boolean productionMode) {
                return productionMode;
            }
        }
        ,
        NEVER{

            @Override
            public boolean shouldSend(boolean productionMode) {
                return false;
            }
        };


        public abstract boolean shouldSend(boolean var1);
    }

    public static enum LogLevel {
        NONE{

            @Override
            public void apply(TrackerConfiguration config) {
            }
        }
        ,
        DEBUG{

            @Override
            public void apply(TrackerConfiguration config) {
                config.setScriptUrl("https://www.google-analytics.com/analytics_debug.js");
            }
        }
        ,
        TRACE{

            @Override
            public void apply(TrackerConfiguration config) {
                DEBUG.apply(config);
                config.setGaDebug("trace", Boolean.TRUE);
            }
        };


        public abstract void apply(TrackerConfiguration var1);
    }
}

