/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sparklinerenderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.sparklinerenderer.SparkLinePlotBand;
import com.vaadin.flow.component.sparklinerenderer.SparklineConfiguration;
import com.vaadin.flow.component.sparklinerenderer.SparklineValues;
import com.vaadin.flow.data.provider.DataKeyMapper;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.StreamResourceWriter;
import com.vaadin.pro.licensechecker.LicenseChecker;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGraphics2D;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.ui.Layer;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SparklineRenderer<ITEM>
extends ComponentRenderer<Component, ITEM> {
    private static final String PROJECT_NAME = "vaadin-grid-sparkline-renderer-flow";
    private static final String PROJECT_VERSION = "1.0.1";
    private static final String UNIT_PX = "PX";
    private static final String SVG_ASPECT_RATIO = "none";
    private ValueProvider<ITEM, SparklineValues> valueProvider;
    private ValueProvider<ITEM, SparklineConfiguration> configurationValueProvider;
    private Double minY = -1.0;
    private Double maxY = 1.0;
    private SparklineConfiguration sparklineConfiguration;
    private boolean licenceVerified;

    public SparklineRenderer(ValueProvider<ITEM, SparklineValues> valueProvider) {
        this.valueProvider = valueProvider;
        this.configurationValueProvider = (ValueProvider & Serializable)item -> new SparklineConfiguration();
    }

    public SparklineRenderer(ValueProvider<ITEM, SparklineValues> valueProvider, ValueProvider<ITEM, SparklineConfiguration> configurationValueProvider) {
        this.valueProvider = valueProvider;
        this.configurationValueProvider = configurationValueProvider;
    }

    public Component createComponent(ITEM item) {
        SparklineValues values = (SparklineValues)this.valueProvider.apply(item);
        SparklineConfiguration configuration = (SparklineConfiguration)this.configurationValueProvider.apply(item);
        switch (configuration.getRenderMode()) {
            case SVG: {
                SvgComponent svgComponent = new SvgComponent();
                svgComponent.setHeight(configuration.getSparklineHeightPx() + UNIT_PX);
                svgComponent.setWidth(configuration.getSparklineWidthPx() + UNIT_PX);
                svgComponent.getElement().setAttribute("data", (AbstractStreamResource)this.getSVGStreamResource(String.valueOf(item.hashCode()), this.drawChart(values, configuration), configuration.getSparklineWidthPx(), configuration.getSparklineHeightPx()));
                return svgComponent;
            }
            case PNG: {
                Image imageComponent = new Image((AbstractStreamResource)this.getPNGStreamResource(String.valueOf(item.hashCode()), this.drawChart(values, configuration), configuration.getSparklineWidthPx(), configuration.getSparklineHeightPx()), "");
                imageComponent.setHeight(configuration.getSparklineHeightPx() + UNIT_PX);
                imageComponent.setWidth(configuration.getSparklineWidthPx() + UNIT_PX);
                return imageComponent;
            }
        }
        return null;
    }

    private JFreeChart drawChart(SparklineValues values, final SparklineConfiguration configuration) {
        TimeSeriesCollection dataSet = new TimeSeriesCollection();
        final TimeSeries data = new TimeSeries((Comparable)((Object)"Sparkline"));
        this.findMinandMaxValues(values);
        if (configuration.isFillGapsWhenNullValues()) {
            values.filterOutNullValues();
        }
        for (int index = 0; index < values.getValues().size(); ++index) {
            SparklineValues.SparklineValue value = values.getValues().get(index);
            SparklineValues.SparklineValue nextValue = null;
            if (index < values.getValues().size() - 1) {
                nextValue = values.getValues().get(index + 1);
            }
            data.addOrUpdate((RegularTimePeriod)new FixedMillisecond(value.getInstant().toEpochMilli()), (Number)value.getValue());
            this.interpolateIfNeeded(data, value, nextValue, configuration.getPlotBands());
        }
        dataSet.addSeries(data);
        DateAxis x = new DateAxis();
        x.setTickUnit(new DateTickUnit(DateTickUnitType.DAY, 1));
        x.setTickLabelsVisible(false);
        x.setTickMarksVisible(false);
        x.setAxisLineVisible(false);
        x.setNegativeArrowVisible(false);
        x.setPositiveArrowVisible(false);
        x.setVisible(false);
        NumberAxis y = new NumberAxis();
        y.setTickLabelsVisible(false);
        y.setTickMarksVisible(false);
        y.setAxisLineVisible(false);
        y.setNegativeArrowVisible(false);
        y.setPositiveArrowVisible(false);
        y.setVisible(false);
        if (configuration.isAutoScaleYAxis()) {
            try {
                y.setRangeWithMargins(this.minY.doubleValue(), this.maxY.doubleValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        XYPlot plot = new XYPlot();
        plot.setInsets(new RectangleInsets(-1.0, -1.0, 0.0, 0.0));
        plot.setDataset((XYDataset)dataSet);
        plot.setDomainAxis((ValueAxis)x);
        plot.setDomainGridlinesVisible(false);
        plot.setDomainCrosshairVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setRangeCrosshairVisible(false);
        plot.setOutlineStroke((Stroke)new BasicStroke(0.0f));
        plot.setBackgroundPaint((Paint)SparklineConfiguration.TRANSPARENT);
        plot.setRangeAxis((ValueAxis)y);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(2){

            public Paint getItemPaint(int row, int column) {
                for (SparkLinePlotBand plotBand : configuration.getPlotBands()) {
                    if (!plotBand.getOptionalLineColor().isPresent() || !(data.getValue(column).doubleValue() >= plotBand.getFromValue()) || !(data.getValue(column).doubleValue() <= plotBand.getToValue())) continue;
                    return plotBand.getOptionalLineColor().get();
                }
                return super.getItemPaint(row, column);
            }
        };
        plot.setRenderer((XYItemRenderer)renderer);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(configuration.getLineWidth().floatValue()));
        renderer.setSeriesPaint(0, (Paint)configuration.getLineColor());
        for (SparkLinePlotBand plotBand : configuration.getPlotBands()) {
            plotBand.getOptionalBackgroundColor().ifPresent(backgroundColor -> {
                IntervalMarker target = new IntervalMarker(plotBand.getFromValue().doubleValue(), plotBand.getToValue().doubleValue());
                target.setPaint((Paint)backgroundColor);
                target.setOutlinePaint((Paint)SparklineConfiguration.TRANSPARENT);
                plot.addRangeMarker((Marker)target, Layer.BACKGROUND);
            });
        }
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        chart.setBackgroundPaint((Paint)SparklineConfiguration.TRANSPARENT);
        chart.setBorderVisible(false);
        return chart;
    }

    private void findMinandMaxValues(SparklineValues values) {
        this.minY = values.getValues().stream().filter(value -> value.getValue() != null).mapToDouble(SparklineValues.SparklineValue::getValue).min().orElse(0.0);
        this.maxY = values.getValues().stream().filter(value -> value.getValue() != null).mapToDouble(SparklineValues.SparklineValue::getValue).max().orElse(0.0);
        if (Math.abs(this.minY) > 1.0E30 || Math.abs(this.maxY) > 1.0E30) {
            System.out.println("Unexpectedly small/large min or max: ");
            values.getValues().forEach(value -> System.out.print(value.getValue() + " "));
            System.out.println();
            this.minY = -1.0;
            this.maxY = 1.0;
        }
        if (this.minY.equals(this.maxY)) {
            if (this.minY.equals(0.0)) {
                this.minY = -1.0;
                this.maxY = 1.0;
            } else {
                this.minY = this.minY - 0.1 * Math.abs(this.minY);
                this.maxY = this.maxY + 0.1 * Math.abs(this.maxY);
            }
        }
    }

    private void interpolateIfNeeded(TimeSeries data, SparklineValues.SparklineValue value, SparklineValues.SparklineValue nextValue, List<SparkLinePlotBand> plotBands) {
        if (nextValue != null && value.getValue() != null && nextValue.getValue() != null) {
            long x1 = value.getInstant().toEpochMilli();
            long x2 = nextValue.getInstant().toEpochMilli();
            double y1 = value.getValue();
            double y2 = nextValue.getValue();
            double delta = (this.maxY - this.minY) / 100.0;
            for (SparkLinePlotBand plotBand : plotBands) {
                double from = plotBand.getFromValue();
                double to = plotBand.getToValue();
                if (from >= y1 && from < y2) {
                    this.addInterpolatedItem(data, x1, x2, y1, y2, from - delta);
                    this.addInterpolatedItem(data, x1, x2, y1, y2, from + delta);
                }
                if (to >= y1 && to < y2) {
                    this.addInterpolatedItem(data, x1, x2, y1, y2, to - delta);
                    this.addInterpolatedItem(data, x1, x2, y1, y2, to + delta);
                }
                if (from <= y1 && from > y2) {
                    this.addInterpolatedItem(data, x1, x2, y1, y2, from - delta);
                    this.addInterpolatedItem(data, x1, x2, y1, y2, from + delta);
                }
                if (!(to <= y1) || !(to > y2)) continue;
                this.addInterpolatedItem(data, x1, x2, y1, y2, to - delta);
                this.addInterpolatedItem(data, x1, x2, y1, y2, to + delta);
            }
        }
    }

    private void addInterpolatedItem(TimeSeries data, long x1, long x2, double y1, double y2, double newY) {
        double newX = (double)x1 + (newY - y1) * (double)(x2 - x1) / (y2 - y1);
        FixedMillisecond newTimestamp = new FixedMillisecond((long)newX);
        if (data.getValue((RegularTimePeriod)newTimestamp) == null) {
            data.add((RegularTimePeriod)newTimestamp, newY);
        }
    }

    private StreamResource getPNGStreamResource(String name, JFreeChart chart, int width, int height) {
        String randomName = UUID.randomUUID().toString() + ".png";
        return new StreamResource(name == null ? randomName : name + ".png", (StreamResourceWriter & Serializable)(stream, session) -> {
            session.lock();
            try {
                ChartUtils.writeChartAsPNG((OutputStream)stream, (JFreeChart)chart, (int)width, (int)height);
            }
            finally {
                session.unlock();
            }
        });
    }

    private StreamResource getSVGStreamResource(String name, JFreeChart chart, int width, int height) {
        String randomName = UUID.randomUUID().toString() + ".svg";
        return new StreamResource(name == null ? randomName : name + ".svg", (StreamResourceWriter & Serializable)(stream, session) -> {
            session.lock();
            try (OutputStreamWriter writer = new OutputStreamWriter(stream);){
                DocumentBuilder docBuilder;
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                try {
                    docBuilder = docBuilderFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e1) {
                    throw new RuntimeException(e1);
                }
                Document document = docBuilder.newDocument();
                Element svgelem = document.createElement("svg");
                document.appendChild(svgelem);
                SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
                chart.draw((Graphics2D)svgGenerator, (Rectangle2D)new Rectangle(width, height));
                Element el = svgGenerator.getRoot();
                el.setAttributeNS(null, "viewBox", "0 0 " + width + " " + height + "");
                el.setAttributeNS(null, "style", "width:100%;height:100%;");
                el.setAttributeNS(null, "preserveAspectRatio", SVG_ASPECT_RATIO);
                svgGenerator.stream(el, (Writer)writer, true, false);
            }
            finally {
                session.unlock();
            }
        });
    }

    public Rendering<ITEM> render(com.vaadin.flow.dom.Element container, DataKeyMapper<ITEM> keyMapper, com.vaadin.flow.dom.Element contentTemplate) {
        UI ui = UI.getCurrent();
        if (ui != null) {
            this.verifyLicense(ui.getSession().getConfiguration().isProductionMode());
        }
        return super.render(container, keyMapper, contentTemplate);
    }

    private void verifyLicense(boolean productionMode) {
        if (!productionMode && !this.licenceVerified) {
            LicenseChecker.checkLicense((String)PROJECT_NAME, (String)PROJECT_VERSION);
            UsageStatistics.markAsUsed((String)PROJECT_NAME, (String)PROJECT_VERSION);
            this.licenceVerified = true;
        }
    }

    @Tag(value="object")
    static class SvgComponent
    extends Component
    implements HasSize,
    HasStyle {
        SvgComponent() {
            this.getElement().setAttribute("type", "image/svg+xml");
        }
    }
}

