/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sparklinerenderer;

import com.vaadin.flow.component.sparklinerenderer.SparkLinePlotBand;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class SparklineConfiguration
implements Serializable {
    public static final Color LIGHT_GREEN = new Color(219, 240, 214);
    public static final Color GREEN = new Color(89, 180, 72);
    public static final Color RED = new Color(179, 49, 70);
    public static final Color YELLOW = new Color(254, 197, 71);
    public static final Color BLUE = new Color(0, 102, 204);
    public static final Color TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color lineColor = BLUE;
    private Float lineWidth = Float.valueOf(0.75f);
    private int sparklineHeightPx = 25;
    private int sparklineWidthPx = 120;
    private boolean fillGapsWhenNullValues = false;
    private boolean autoScaleYAxis = false;
    private List<SparkLinePlotBand> plotBands;
    private RenderMode renderMode = RenderMode.SVG;

    public SparklineConfiguration() {
        this.plotBands = new ArrayList<SparkLinePlotBand>();
    }

    public void addPlotBand(SparkLinePlotBand plotBand) {
        this.plotBands.add(plotBand);
    }

    public void clearPlotBands() {
        this.plotBands.clear();
    }

    public List<SparkLinePlotBand> getPlotBands() {
        return this.plotBands;
    }

    public void setPlotBands(List<SparkLinePlotBand> plotBands) {
        this.plotBands = plotBands;
    }

    public boolean isFillGapsWhenNullValues() {
        return this.fillGapsWhenNullValues;
    }

    public void setFillGapsWhenNullValues(boolean fillGapsWhenNullValues) {
        this.fillGapsWhenNullValues = fillGapsWhenNullValues;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(Float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public int getSparklineHeightPx() {
        return this.sparklineHeightPx;
    }

    public void setSparklineHeightPx(int sparklineHeightPx) {
        this.sparklineHeightPx = sparklineHeightPx;
    }

    public int getSparklineWidthPx() {
        return this.sparklineWidthPx;
    }

    public void setSparklineWidthPx(int sparklineWidthPx) {
        this.sparklineWidthPx = sparklineWidthPx;
    }

    public SparklineConfiguration withLineWidth(Float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public SparklineConfiguration withSparklineHeightPx(int sparklineHeightPx) {
        this.sparklineHeightPx = sparklineHeightPx;
        return this;
    }

    public SparklineConfiguration withSparklineWidthPx(int sparklineWidthPx) {
        this.sparklineWidthPx = sparklineWidthPx;
        return this;
    }

    public SparklineConfiguration withLineColor(Color lineColor) {
        this.lineColor = lineColor;
        return this;
    }

    public SparklineConfiguration withFillGapsWhenNullValues(boolean fillGapsWhenNullValues) {
        this.fillGapsWhenNullValues = fillGapsWhenNullValues;
        return this;
    }

    public SparklineConfiguration withPlotBands(List<SparkLinePlotBand> plotBands) {
        this.plotBands = plotBands;
        return this;
    }

    public SparklineConfiguration withPlotBand(SparkLinePlotBand plotBand) {
        if (this.plotBands == null) {
            this.plotBands = new ArrayList<SparkLinePlotBand>();
        }
        this.plotBands.add(plotBand);
        return this;
    }

    public void setAutoScaleYAxis(boolean autoScaleYAxis) {
        this.autoScaleYAxis = autoScaleYAxis;
    }

    public SparklineConfiguration withAutoScaleYAxis(boolean autoScaleYAxis) {
        this.autoScaleYAxis = autoScaleYAxis;
        return this;
    }

    public boolean isAutoScaleYAxis() {
        return this.autoScaleYAxis;
    }

    public RenderMode getRenderMode() {
        return this.renderMode;
    }

    public void setRenderMode(RenderMode renderMode) {
        this.renderMode = renderMode;
    }

    public SparklineConfiguration withRenderMode(RenderMode renderMode) {
        this.renderMode = renderMode;
        return this;
    }

    public static enum RenderMode {
        SVG,
        PNG;

    }
}

