/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.papermenubutton;

import com.github.appreciated.papermenubutton.HorizontalAlignment;
import com.github.appreciated.papermenubutton.VerticalAlignment;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;

@Tag(value="paper-menu-button")
@HtmlImport.Container(value={@HtmlImport(value="frontend://bower_components/paper-menu-button/paper-menu-button.html"), @HtmlImport(value="frontend://bower_components/neon-animation/web-animations.html")})
public class PaperMenuButton
extends Component
implements HasStyle {
    private Div contentHolder;
    private Component triggerComponent;
    private Component contentComponent;

    public PaperMenuButton(Component triggerComponent, Component contentComponent) {
        this.setTriggerComponent(triggerComponent);
        this.setContentComponent(contentComponent);
        this.setVerticalAlignment(VerticalAlignment.TOP);
        this.setHorizontalAlignment(HorizontalAlignment.LEFT);
        this.getElement().synchronizeProperty("opened", "opened-changed");
    }

    public Component getContentComponent() {
        return this.contentComponent;
    }

    public void setContentComponent(Component content) {
        this.contentComponent = content;
        if (this.contentHolder == null) {
            this.contentHolder = new Div();
            this.contentHolder.getElement().setAttribute("slot", "dropdown-content");
            this.getElement().appendChild(new Element[]{this.contentHolder.getElement()});
        }
        this.contentHolder.removeAll();
        this.contentHolder.add(new Component[]{this.contentComponent});
    }

    public Component getTriggerComponent() {
        return this.triggerComponent;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.getElement().setAttribute("vertical-align", verticalAlignment.getAlignment());
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.getElement().setAttribute("horizontal-align", horizontalAlignment.getAlignment());
    }

    public void setDynamicAlign(boolean dynamicAlign) {
        this.getElement().setProperty("dynamicAlign", dynamicAlign);
    }

    public void setNoOverlap(boolean overlap) {
        this.getElement().setProperty("noOverlap", overlap);
    }

    public void setIgnoreSelect(boolean ignoreSelect) {
        this.getElement().setProperty("ignoreSelect", ignoreSelect);
    }

    public void setRestoreFocusOnClose(boolean restoreFocusOnClose) {
        this.getElement().setProperty("restoreFocusOnClose", restoreFocusOnClose);
    }

    public void setAllowOutsideScroll(boolean allowOutsideScroll) {
        this.getElement().setProperty("allowOutsideScroll", allowOutsideScroll);
    }

    public void setCloseOnActivate(boolean closeOnActivate) {
        this.getElement().setProperty("closeOnActivate", closeOnActivate);
    }

    public void setVerticalOffset(int verticalOffset) {
        this.getElement().setProperty("verticalOffset", (double)verticalOffset);
    }

    public void setHorizontalOffset(int horizontalOffset) {
        this.getElement().setProperty("horizontalOffset", (double)horizontalOffset);
    }

    public void setNoAnimations(boolean noAnimations) {
        this.getElement().setProperty("noAnimations", noAnimations);
    }

    public void open() {
        this.getElement().callFunction("open", new Serializable[0]);
    }

    public void close() {
        this.getElement().callFunction("close", new Serializable[0]);
    }

    public boolean isOpened() {
        return this.getElement().getProperty("opened", false);
    }

    public void setTriggerComponent(Component triggerComponent) {
        if (this.triggerComponent != null) {
            this.getElement().removeChild(new Element[]{this.triggerComponent.getElement()});
        }
        this.triggerComponent = triggerComponent;
        this.triggerComponent.getElement().setAttribute("slot", "dropdown-trigger");
        this.getElement().appendChild(new Element[]{triggerComponent.getElement()});
    }
}

