/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.card;

import com.github.appreciated.card.StatefulCard;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class StatefulCardGroup<T extends StatefulCard>
extends Composite<VerticalLayout> {
    private StatefulCard currentFocus;
    private Consumer<T> listener;
    private List<T> cards = new ArrayList<T>();

    public StatefulCardGroup(T ... cards) {
        this.add((StatefulCard[])cards);
        ((VerticalLayout)this.getContent()).setMargin(false);
        ((VerticalLayout)this.getContent()).setPadding(false);
        ((VerticalLayout)this.getContent()).setSpacing(false);
    }

    public void add(T ... cards) {
        ((VerticalLayout)this.getContent()).add(cards);
        ((VerticalLayout)this.getContent()).add(cards);
        Arrays.stream(cards).forEach(card -> card.addClickListener((ComponentEventListener & Serializable)event -> this.setState(card)));
        this.cards.addAll(Arrays.asList(cards));
    }

    public void setState(T nextFocus, boolean notifyListeners) {
        if (nextFocus != this.currentFocus) {
            ((StatefulCard)((Object)nextFocus)).setSelected(true);
            if (this.currentFocus != null) {
                this.currentFocus.setSelected(false);
            }
            this.currentFocus = nextFocus;
            if (this.listener != null && notifyListeners) {
                this.listener.accept(nextFocus);
            }
        }
    }

    public StatefulCard getState() {
        return this.currentFocus;
    }

    public void setState(T nextFocus) {
        this.setState(nextFocus, true);
    }

    public StatefulCardGroup<T> withStateChangedListener(Consumer<T> listener) {
        this.setStateChangedListener(listener);
        return this;
    }

    public void setStateChangedListener(Consumer<T> listener) {
        this.listener = listener;
    }

    public void setHighlight(boolean enabled) {
        if (enabled) {
            ((VerticalLayout)this.getContent()).getStyle().remove("--card-state-highlight");
        } else {
            ((VerticalLayout)this.getContent()).getStyle().set("--card-state-highlight", "transparent");
        }
    }

    public List<T> getCards() {
        return this.cards;
    }
}

