/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.card;

import com.github.appreciated.card.AbstractCard;
import com.github.appreciated.card.action.ActionButton;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

@Tag(value="clickable-card")
@HtmlImport(value="frontend://com/github/appreciated/card/clickable-card.html")
public class ClickableCard
extends AbstractCard<ClickableCard>
implements ClickNotifier {
    private List<Class> ignoredClasses;

    public ClickableCard() {
        this(null);
    }

    public ClickableCard(Component ... components) {
        this((ComponentEventListener)null, components);
    }

    public ClickableCard(ComponentEventListener listener, Component ... components) {
        super(components);
        if (listener != null) {
            this.addClickListener(listener);
        }
    }

    public Registration addClickListener(ComponentEventListener listener) {
        if (this instanceof Component) {
            return ComponentUtil.addListener((Component)this.getContent(), ClickEvent.class, (ComponentEventListener)listener);
        }
        throw new IllegalStateException(String.format("The class '%s' doesn't extend '%s'. Make your implementation for the method '%s'.", ((Object)((Object)this)).getClass().getName(), Component.class.getSimpleName(), "addClickListener"));
    }

    public ClickableCard withClickListener(ComponentEventListener listener) {
        this.addClickListener(listener);
        return this;
    }

    @Override
    public void add(Component ... components) {
        super.add(components);
        if (this.ignoredClasses == null) {
            this.ignoredClasses = this.getIgnoredComponentClasses();
        }
        this.checkPreventComponentEventPropagation(Arrays.stream(components));
    }

    private void checkPreventComponentEventPropagation(Stream<Component> components) {
        components.forEach(component -> {
            if (this.ignoredClasses.contains(component.getClass())) {
                this.preventElementEventPropagation((Component)component);
            } else if (this.getChildren().count() > 0L) {
                this.checkPreventComponentEventPropagation(component.getChildren());
            }
        });
    }

    public List<Class> getIgnoredComponentClasses() {
        return Arrays.asList(Button.class, ActionButton.class);
    }

    private void preventElementEventPropagation(Component component) {
        this.getElement().callFunction("preventElementEventPropagation", new Serializable[]{component.getElement()});
    }

    public ClickableCard withElevationOnActionEnabled(boolean enabled) {
        this.setElevationOnActionEnabled(enabled);
        return this;
    }

    public void setElevationOnActionEnabled(boolean enable) {
        this.getElement().setProperty("elevationEnabled", enable);
    }
}

