/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.card;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.templatemodel.TemplateModel;

public abstract class AbstractCard<T extends AbstractCard>
extends PolymerTemplate<TemplateModel>
implements HasComponents,
FlexComponent,
ClickNotifier {
    private VerticalLayout contentHolder;
    @Id(value="card-content")
    private Div content;

    public AbstractCard() {
        this(null, null);
    }

    public AbstractCard(Component ... components) {
        this.setElevation(1);
        this.contentHolder = new VerticalLayout();
        this.contentHolder.setPadding(false);
        this.contentHolder.setMargin(false);
        this.contentHolder.setSpacing(false);
        this.contentHolder.setSizeFull();
        this.getElement().appendChild(new Element[]{this.contentHolder.getElement()});
        if (components != null) {
            this.add(components);
        }
    }

    public void add(Component ... components) {
        this.contentHolder.add(components);
    }

    public int getElevation() {
        return Integer.parseInt(this.getElement().getAttribute("elevation"));
    }

    public void setElevation(int elevation) {
        if (elevation < 6 && elevation >= 0) {
            this.content.getElement().setAttribute("elevation", String.valueOf(elevation));
        }
    }

    public T withElevation(int elevation) {
        this.setElevation(elevation);
        return (T)((Object)this);
    }

    public VerticalLayout getContent() {
        return this.contentHolder;
    }

    public T withBorderRadius(String size) {
        this.setBorderRadius(size);
        return (T)((Object)this);
    }

    public void setBorderRadius(String size) {
        this.getStyle().set("--lumo-border-radius", size);
    }

    public void setBackground(String background) {
        this.getTemplateDiv().getStyle().set("background", background);
    }

    public Div getTemplateDiv() {
        return this.content;
    }

    public void setTransition(String transition) {
        this.getTemplateDiv().getStyle().set("transition", transition);
    }

    public void setColor(String color) {
        this.getStyle().set("--lumo-header-text-color", color).set("--lumo-body-text-color", color);
    }

    public T withWidth(String width) {
        this.setWidth(width);
        return (T)((Object)this);
    }

    public T withHeight(String height) {
        this.setHeight(height);
        return (T)((Object)this);
    }
}

