/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.router.navigation;

import com.github.appreciated.app.layout.router.navigation.RouteSimilarity;
import com.github.appreciated.app.layout.session.UIAttributes;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteData;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;

public class UpNavigationHelper {
    private HashMap<RouteData, String> registeredRoutes = new HashMap();

    private UpNavigationHelper() {
    }

    public static boolean routeHasUpNavigation(Class<? extends Component> navigationTarget) {
        return UpNavigationHelper.getClosestRoute(navigationTarget).isPresent();
    }

    public static Optional<RouteData> getClosestRoute(Class<? extends Component> navigationTarget) {
        String currentRoute = RouteConfiguration.forSessionScope().getUrl(navigationTarget);
        if (currentRoute.lastIndexOf("/") > 0) {
            String[] currentRouteParts = currentRoute.substring(0, currentRoute.lastIndexOf("/")).split("/");
            Optional<RouteSimilarity> result = RouteConfiguration.forApplicationScope().getAvailableRoutes().stream().filter(routeData -> !routeData.getUrl().equals(currentRoute)).map(routeData -> new RouteSimilarity((RouteData)routeData, currentRouteParts)).max(Comparator.comparingInt(RouteSimilarity::getSimilarity));
            if (result.isPresent()) {
                return Optional.ofNullable(result.get().getRouteData());
            }
        }
        return Optional.empty();
    }

    public static void performUpNavigation(Class<? extends Component> currentNavigation) {
        UpNavigationHelper.getClosestRoute(currentNavigation).ifPresent(routeData -> UI.getCurrent().navigate(routeData.getUrl()));
    }

    public static boolean shouldHighlight(Class<? extends Component> className, Location location) {
        String[] currentRouteParts = location.getSegments().toArray(new String[0]);
        Optional<RouteSimilarity> result = UpNavigationHelper.getUpNavigationHelper().registeredRoutes.keySet().stream().map(s -> new RouteSimilarity((RouteData)s, currentRouteParts)).max(Comparator.comparingInt(RouteSimilarity::getSimilarity));
        return result.filter(routeSimilarity -> routeSimilarity.getRoute() == className).isPresent();
    }

    public static UpNavigationHelper getUpNavigationHelper() {
        if (UIAttributes.get(UpNavigationHelper.class) == null) {
            UpNavigationHelper.setUpNavigationHelper();
        }
        return UIAttributes.get(UpNavigationHelper.class);
    }

    public static void setUpNavigationHelper() {
        UIAttributes.set(UpNavigationHelper.class, new UpNavigationHelper());
    }

    public static void registerNavigationRoute(Class<? extends Component> className) {
        UpNavigationHelper.getUpNavigationHelper().register(className);
    }

    public void register(Class<? extends Component> className) {
        RouteConfiguration.forSessionScope().getAvailableRoutes().stream().filter(routeData -> routeData.getNavigationTarget() == className).findFirst().ifPresent(routeData -> this.registeredRoutes.put((RouteData)routeData, RouteConfiguration.forSessionScope().getUrl(className)));
    }
}

