/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.router;

import com.github.appreciated.app.layout.behaviour.AppLayout;
import com.github.appreciated.app.layout.router.navigation.UpNavigationHelper;
import com.github.appreciated.app.layout.session.UIAttributes;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.router.AfterNavigationListener;
import com.vaadin.flow.router.RouterLayout;
import java.io.Serializable;

@HtmlImport(value="frontend://src/com/github/appreciated/app-layout/app-layout-styles.html")
public class AppLayoutRouterLayoutBase
extends Composite<Div>
implements RouterLayout {
    private HasElement currentContent;
    private AppLayout layout;

    public AppLayoutRouterLayoutBase() {
        ((Div)this.getContent()).setSizeFull();
        ((Div)this.getContent()).getElement().getStyle().set("overflow", "auto");
    }

    public static AppLayout getCurrent() {
        return UIAttributes.get(AppLayout.class);
    }

    public void init(AppLayout layout) {
        this.setLayout(layout);
        if (this.currentContent != null) {
            this.showRouterLayoutContent(this.currentContent);
        }
    }

    public void setLayout(AppLayout layout) {
        ((Div)this.getContent()).removeAll();
        this.layout = layout;
        ((Div)this.getContent()).add(new Component[]{layout});
        UIAttributes.set(AppLayout.class, layout);
    }

    public void showRouterLayoutContent(HasElement content) {
        this.currentContent = content;
        this.layout.setAppLayoutContent(content);
        if (this.layout.isUpNavigationEnabled()) {
            this.setUpNavigation(content);
        }
        this.layout.setPercentageHeight(this.currentContent.getElement().getStyle().get("height") != null && this.currentContent.getElement().getStyle().get("height").endsWith("%"));
    }

    private void setUpNavigation(HasElement content) {
        if (content instanceof Component) {
            this.layout.showUpNavigation(UpNavigationHelper.routeHasUpNavigation(((Component)content).getClass()));
        } else {
            this.layout.showUpNavigation(false);
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getUI().ifPresent(ui -> ui.addAfterNavigationListener((AfterNavigationListener & Serializable)event -> this.closeDrawerIfNotPersistent()));
    }

    public void closeDrawerIfNotPersistent() {
        this.layout.closeDrawerIfNotPersistent();
    }

    public void closeDrawer() {
        this.layout.closeDrawer();
    }

    public void toggleDrawer() {
        this.layout.toggleDrawer();
    }

    public void openDrawer() {
        this.layout.openDrawer();
    }

    public AppLayout getAppLayout() {
        return this.layout;
    }

    public final AppLayout createAppLayoutInstance() {
        return null;
    }
}

