/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.notification.entitiy;

import com.github.appreciated.app.layout.notification.entitiy.Notification;
import com.github.appreciated.app.layout.notification.entitiy.Priority;
import java.time.LocalDateTime;
import java.util.Objects;

public class DefaultNotification
implements Notification {
    private String title;
    private String description;
    private String image;
    private Priority priority = Priority.MEDIUM;
    private boolean isSticky = false;
    private boolean isRead = false;
    private LocalDateTime creationTime = LocalDateTime.now();
    private boolean dismissable = true;

    public DefaultNotification(String title, String description) {
        this(title, description, null);
    }

    public DefaultNotification(String title, String description, Priority priority) {
        Objects.requireNonNull(title, "The title must not be null.");
        Objects.requireNonNull(description, "The description must not be null.");
        this.title = title;
        this.description = description;
        if (priority != null) {
            this.priority = priority;
        }
    }

    public DefaultNotification(String title, String description, Priority priority, boolean isSticky) {
        this(title, description, priority);
        this.isSticky = isSticky;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        Objects.requireNonNull(title, "The title must not be null.");
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        Objects.requireNonNull(description, "The description must not be null.");
        this.description = description;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public boolean isDismissable() {
        return this.dismissable;
    }

    @Override
    public void setDismissable(boolean dismissable) {
        this.dismissable = dismissable;
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public boolean isSticky() {
        return this.isSticky;
    }

    @Override
    public boolean isRead() {
        return this.isRead;
    }

    @Override
    public LocalDateTime getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setCreationTime(LocalDateTime creationTime) {
        Objects.requireNonNull(creationTime, "The creationTime must not be null.");
        this.creationTime = creationTime;
    }

    @Override
    public void setRead(boolean isRead) {
        this.isRead = isRead;
    }

    @Override
    public void setSticky(boolean isSticky) {
        this.isSticky = isSticky;
    }
}

