/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.notification.component;

import com.github.appreciated.app.layout.notification.NotificationHolder;
import com.github.appreciated.card.Card;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.Command;
import java.io.Serializable;

public class NotificationsView
extends Composite<VerticalLayout> {
    private Boolean showAll = Boolean.FALSE;
    private NotificationHolder holder;
    private String noNotificationText = "No Notifications";
    private String showAllText = "Show all";
    private Button showAllButton;
    private Label noNotificationsLabel;
    private Command showAllCommand = (Command & Serializable)() -> {
        this.showAll = Boolean.TRUE;
        this.initView();
    };

    public NotificationsView(NotificationHolder holder) {
        VerticalLayout content = (VerticalLayout)this.getContent();
        content.setMargin(false);
        content.setPadding(false);
        content.setWidth("var(--notification-width)");
        this.getElement().getStyle().set("padding", "5px 2px 18px 8px");
        this.holder = holder;
        this.initView();
    }

    void initView() {
        VerticalLayout content = (VerticalLayout)this.getContent();
        content.removeAll();
        if (this.holder.getNotificationSize() > 0) {
            content.add(this.holder.getNotificationViews(this.showAll));
            this.getElement().getClassList().add((Object)"app-layout-notification-list");
            if (!this.showAll.booleanValue() && this.holder.getNotificationSize() > 4) {
                this.showAllButton = new Button(this.showAllText);
                this.showAllButton.setWidth("100%");
                this.showAllButton.setHeight("28px");
                this.showAllButton.addClickListener((ComponentEventListener & Serializable)clickEvent -> this.showAllCommand.execute());
                content.add(new Component[]{this.showAllButton});
            }
        } else {
            this.noNotificationsLabel = new Label(this.noNotificationText);
            this.noNotificationsLabel.getStyle().set("color", "var(--app-layout-notification-font-color)").set("font-size", "var(--app-layout-font-size-menu)");
            HorizontalLayout wrapper = new HorizontalLayout(new Component[]{this.noNotificationsLabel});
            wrapper.setWidth("100%");
            wrapper.setPadding(true);
            wrapper.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
            Card card = new Card(new Component[]{wrapper});
            card.getTemplateDiv().getStyle().set("background", "var(--app-layout-notification-background-color)");
            card.setWidth("100%");
            content.add(new Component[]{card});
        }
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public void refreshNotificationViews(NotificationHolder component) {
        this.initView();
    }

    public void setShowAllCommand(Command showAllCommand) {
        this.showAllCommand = showAllCommand;
    }

    public void setShowAllText(String showAllText) {
        this.showAllText = showAllText;
        if (this.showAllButton != null) {
            this.showAllButton.setText(showAllText);
        }
    }

    public void setNoNotificationText(String noNotificationText) {
        this.noNotificationText = noNotificationText;
        if (this.noNotificationsLabel != null) {
            this.noNotificationsLabel.setText(noNotificationText);
        }
    }
}

