/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.notification.component;

import com.github.appreciated.app.layout.component.menu.RoundImage;
import com.github.appreciated.app.layout.notification.NotificationHolder;
import com.github.appreciated.app.layout.notification.entitiy.Notification;
import com.github.appreciated.ripple.PaperRipple;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.dom.DomEventListener;

public class NotificationViewWithoutWrapper<T extends Notification>
extends Div {
    public NotificationViewWithoutWrapper(T info, NotificationHolder<T> holder) {
        this(info, holder, null);
    }

    public NotificationViewWithoutWrapper(T info, NotificationHolder<T> holder, DomEventListener clickEvent) {
        this.getElement().getStyle().set("width", "100%").set("color", "#000000");
        Label title = new Label(info.getTitle());
        title.getElement().getStyle().set("font-size", "15px").set("font-weight", "500");
        Label dot = new Label("\u00b7");
        dot.getElement().getStyle().set("margin-left", "5px");
        Label timeAgo = new Label(holder.getDateTimeFormatter().apply(info));
        timeAgo.getElement().getStyle().set("font-size", "13px").set("margin-left", "5px").set("font-weight", "300");
        Label description = new Label(info.getDescription());
        description.setWidth("100%");
        description.getElement().getStyle().set("font-size", "15px").set("font-weight", "400").set("white-space", "nowrap").set("text-overflow", "ellipsis").set("overflow", "hidden");
        HorizontalLayout descriptionWrapper = new HorizontalLayout(new Component[]{description});
        descriptionWrapper.setWidth("100%");
        if (info.getImage() != null) {
            RoundImage image = new RoundImage(info.getImage());
            descriptionWrapper.add(new Component[]{image});
        }
        HorizontalLayout headerLine = new HorizontalLayout(new Component[]{title, dot, timeAgo});
        headerLine.setSpacing(false);
        headerLine.setAlignItems(FlexComponent.Alignment.CENTER);
        this.add(new Component[]{headerLine});
        this.add(new Component[]{descriptionWrapper});
        if (clickEvent != null) {
            this.getElement().addEventListener("click", clickEvent);
        }
        if (clickEvent != null) {
            this.add(new Component[]{new PaperRipple()});
        }
    }
}

