/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.notification.component;

import com.github.appreciated.app.layout.component.appbar.IconButton;
import com.github.appreciated.app.layout.component.menu.RoundImage;
import com.github.appreciated.app.layout.notification.NotificationHolder;
import com.github.appreciated.app.layout.notification.entitiy.Notification;
import com.github.appreciated.app.layout.notification.listener.NotificationListener;
import com.github.appreciated.app.layout.webcomponents.papericonbutton.PaperIconButton;
import com.github.appreciated.card.RippleClickableCard;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import java.io.Serializable;

public class NotificationView<T extends Notification>
extends RippleClickableCard {
    private final VerticalLayout wrapper;
    private final T info;
    private final NotificationHolder<T> holder;
    private IconButton dismissButton;
    private DomListenerRegistration registration;

    public NotificationView(T info, NotificationHolder<T> holder) {
        this(info, holder, null);
    }

    public NotificationView(T info, NotificationHolder<T> holder, NotificationListener listener) {
        this.info = info;
        this.holder = holder;
        this.setWidth("100%");
        Label title = new Label(info.getTitle());
        title.getElement().getStyle().set("font-size", "15px").set("font-weight", "500");
        Label dot = new Label("\u00b7");
        dot.getElement().getStyle().set("margin-left", "5px");
        Label timeAgo = new Label(holder.getDateTimeFormatter().apply(info));
        timeAgo.getElement().getStyle().set("font-size", "13px").set("margin-left", "5px").set("font-weight", "300");
        Label description = new Label(info.getDescription());
        description.setWidth("100%");
        description.getElement().getStyle().set("font-size", "15px").set("font-weight", "400").set("white-space", "nowrap").set("text-overflow", "ellipsis").set("overflow", "hidden");
        HorizontalLayout descriptionWrapper = new HorizontalLayout(new Component[]{description});
        descriptionWrapper.setWidth("100%");
        if (info.getImage() != null) {
            RoundImage image = new RoundImage(info.getImage());
            descriptionWrapper.add(new Component[]{image});
        }
        this.setHighlightBorder(!info.isRead());
        HorizontalLayout headerLine = new HorizontalLayout(new Component[]{title, dot, timeAgo});
        headerLine.setSpacing(false);
        headerLine.setAlignItems(FlexComponent.Alignment.CENTER);
        this.wrapper = new VerticalLayout(new Component[]{headerLine, descriptionWrapper});
        this.wrapper.setMargin(false);
        this.wrapper.setPadding(false);
        this.wrapper.setSpacing(false);
        this.add(new Component[]{this.wrapper});
        this.add(new Component[]{headerLine});
        this.add(new Component[]{descriptionWrapper});
        this.getContent().getStyle().set("background", "var(--app-layout-notification-background-color)");
        this.getContent().setPadding(true);
        this.setNotificationListener(listener);
        if (info.isDismissable()) {
            this.dismissButton = new IconButton(VaadinIcon.CLOSE_BIG.create(), (ComponentEventListener<ClickEvent<PaperIconButton>>)(ComponentEventListener & Serializable)paperIconButtonClickEvent -> {
                if (listener != null) {
                    listener.onDismiss();
                }
            });
            this.dismissButton.getStyle().set("position", "absolute").set("right", "0px").set("margin", "1px 5px 0 0").set("top", "0px");
            this.dismissButton.getButton().getElement().getStyle().set("line-height", "0px");
            this.dismissButton.setWidth("27px");
            this.dismissButton.setHeight("27px");
            this.add(new Component[]{this.dismissButton});
        }
    }

    public void setHighlightBorder(boolean highlight) {
        this.getContent().getStyle().set("border-left", "3px solid " + (highlight ? this.info.getPriority().getStyle() : "transparent"));
    }

    public void setNotificationListener(NotificationListener listener) {
        if (listener != null && this.registration == null) {
            this.registration = this.getElement().addEventListener("click", (DomEventListener & Serializable)domEvent -> listener.onClick());
        }
    }
}

