/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.notification.component;

import com.github.appreciated.app.layout.component.appbar.IconBadgeButton;
import com.github.appreciated.app.layout.notification.NotificationHolder;
import com.github.appreciated.app.layout.notification.NotificationsChangeListener;
import com.github.appreciated.app.layout.notification.component.NotificationViewWithoutWrapper;
import com.github.appreciated.app.layout.notification.component.NotificationsView;
import com.github.appreciated.app.layout.notification.entitiy.Notification;
import com.github.appreciated.papermenubutton.HorizontalAlignment;
import com.github.appreciated.papermenubutton.PaperMenuButton;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;

@HtmlImport(value="frontend://src/com/github/appreciated/app-layout/styles/app-bar-notification-button-style.html")
public class AppBarNotificationButton<T extends Notification>
extends PaperMenuButton {
    private NotificationsView notificationsView;

    public AppBarNotificationButton(VaadinIcon icon, final NotificationHolder<T> holder) {
        super((Component)new IconBadgeButton(icon), (Component)new Div());
        this.notificationsView = new NotificationsView(holder);
        this.setContentComponent((Component)this.notificationsView);
        this.setClassName("app-bar-notification-button");
        this.getStyle().set("--paper-menu-button-dropdown-background", "transparent").set("--shadow-elevation-2dp_-_box-shadow", "0px").set("--paper-menu-button-dropdown_-_margin-top", "var(--app-layout-bar-height)").set("--paper-menu-button-dropdown_-_margin-right", "7px");
        this.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        holder.addNotificationsChangeListener(new NotificationsChangeListener<T>(){

            @Override
            public void onNotificationChanges(NotificationHolder<T> holder2) {
                AppBarNotificationButton.this.refreshNotifications();
            }

            @Override
            public void onNotificationAdded(T notification) {
                if (!AppBarNotificationButton.this.isOpened()) {
                    NotificationViewWithoutWrapper view = new NotificationViewWithoutWrapper(notification, holder);
                    view.setWidth("200px");
                    com.vaadin.flow.component.notification.Notification notificationView = new com.vaadin.flow.component.notification.Notification(new Component[]{view});
                    notificationView.setPosition(Notification.Position.TOP_END);
                    notificationView.setDuration(2000);
                    notificationView.open();
                }
                AppBarNotificationButton.this.refreshNotifications();
            }

            @Override
            public void onNotificationRemoved(T notification) {
            }
        });
        holder.addClickListener(newStatus -> this.getUI().ifPresent(ui -> ui.access(() -> ((AppBarNotificationButton)this).close())));
        holder.bind(((IconBadgeButton)this.getTriggerComponent()).getBadge());
    }

    public void refreshNotifications() {
        this.notificationsView.initView();
    }

    public NotificationsView getNotificationsView() {
        return this.notificationsView;
    }
}

