/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.notification;

import com.github.appreciated.app.layout.builder.interfaces.PairComponentFactory;
import com.github.appreciated.app.layout.notification.NotificationsChangeListener;
import com.github.appreciated.app.layout.notification.entitiy.Notification;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class NotificationHolder<T extends Notification>
implements Serializable {
    private PairComponentFactory<NotificationHolder<T>, T> componentProvider;
    private List<T> notifications = new ArrayList<T>();
    private List<NotificationsChangeListener<T>> notificationsChangeListeners = new ArrayList<NotificationsChangeListener<T>>();
    private List<NotificationClickListener<T>> clickListeners = new ArrayList<NotificationClickListener<T>>();
    private Notification recentNotification;
    private List<HasText> badgeHolderComponents = new ArrayList<HasText>();
    private Comparator<T> comparator = Comparator.reverseOrder();

    public NotificationHolder(NotificationClickListener<T> listener, T ... notifications) {
        this(listener);
        this.notifications.addAll(Arrays.asList(notifications));
    }

    public NotificationHolder(NotificationClickListener<T> listener) {
        if (listener != null) {
            this.addClickListener(listener);
        }
        this.setComponentProvider(this.getComponentProvider());
    }

    public NotificationHolder(T ... notifications) {
        this((NotificationClickListener)null);
        this.notifications.addAll(Arrays.asList(notifications));
    }

    public NotificationHolder(Collection<T> notifications) {
        this((NotificationClickListener)null);
        this.notifications.addAll(notifications);
    }

    public void addClickListener(NotificationClickListener<T> listener) {
        this.clickListeners.add(listener);
    }

    abstract PairComponentFactory<NotificationHolder<T>, T> getComponentProvider();

    public void setComponentProvider(PairComponentFactory<NotificationHolder<T>, T> componentProvider) {
        this.componentProvider = componentProvider;
    }

    public NotificationHolder(NotificationClickListener<T> listener, Collection<T> notifications) {
        this(listener);
        this.notifications.addAll(notifications);
    }

    public int getNotificationSize() {
        return this.notifications.size();
    }

    public List<Component> getNotifications(boolean showAll) {
        List<T> components = this.getNotifications();
        if (!showAll) {
            components = components.size() > 4 ? components.subList(0, 4) : components;
        }
        return components.stream().sorted(this.comparator).map(this::getComponent).collect(Collectors.toList());
    }

    public List<T> getNotifications() {
        this.notifications.sort(this.comparator);
        return this.notifications;
    }

    private Component getComponent(T message) {
        return this.componentProvider.getComponent(this, message);
    }

    public void addNotification(T notification) {
        this.recentNotification = notification;
        this.notifications.add(notification);
        this.notifyListeners();
        this.notifyAddListeners(notification);
        this.updateBadgeCaptions();
    }

    private void notifyListeners() {
        this.notificationsChangeListeners.forEach(listener -> listener.onNotificationChanges(this));
    }

    private void notifyAddListeners(T notification) {
        this.notificationsChangeListeners.forEach(listener -> listener.onNotificationAdded(notification));
    }

    public void updateBadgeCaptions() {
        this.badgeHolderComponents.forEach(this::updateBadgeCaption);
    }

    private void updateBadgeCaption(HasText hasText) {
        if (hasText != null) {
            int unread = this.getUnreadNotifications();
            String value = unread < 1 ? String.valueOf(0) : (unread < 10 ? String.valueOf(unread) : "9+");
            hasText.setText(value);
            if (hasText instanceof Component) {
                ((Component)hasText).setVisible(unread > 0);
            }
        }
    }

    public int getUnreadNotifications() {
        return (int)this.notifications.stream().filter(notification -> !notification.isRead()).count();
    }

    public void clearNotifications() {
        this.notifications.clear();
        this.notifyListeners();
        this.updateBadgeCaptions();
    }

    public void addNotificationsChangeListener(NotificationsChangeListener<T> listener) {
        this.notificationsChangeListeners.add(listener);
    }

    public Component[] getNotificationViews(boolean showAll) {
        List<T> components = this.getNotifications();
        if (!showAll) {
            components = components.size() > 4 ? components.subList(0, 4) : components;
        }
        return components.stream().sorted(this.comparator).map(this::getComponent).collect(Collectors.toList()).toArray(new Component[0]);
    }

    public void onNotificationClicked(T info) {
        this.notifyClickListeners(info);
        this.notifyListeners();
        this.updateBadgeCaptions();
    }

    private void notifyClickListeners(T info) {
        info.setRead(true);
        this.clickListeners.forEach(listener -> listener.onNotificationClicked(info));
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public void removeClickListener(NotificationClickListener<T> listener) {
        this.clickListeners.remove(listener);
    }

    public Notification getMostRecentNotification() {
        return this.recentNotification;
    }

    public void bind(HasText text) {
        this.addBadgeHolderComponent(text);
        this.updateBadgeCaptions();
    }

    private void addBadgeHolderComponent(HasText text) {
        this.badgeHolderComponents.add(text);
        this.updateBadgeCaption(text);
    }

    public void onNotificationDismissed(T info) {
        if (!info.isSticky()) {
            this.removeNotification(info);
        }
        this.notifyListeners();
    }

    public void removeNotification(T notification) {
        this.notifications.remove(notification);
        this.notifyListeners();
        this.notifyRemoveListeners(notification);
        this.updateBadgeCaptions();
    }

    private void notifyRemoveListeners(T notification) {
        this.notificationsChangeListeners.forEach(listener -> listener.onNotificationRemoved(notification));
    }

    public abstract Function<T, String> getDateTimeFormatter();

    public abstract void setDateTimeFormatter(Function<T, String> var1);

    public static interface NotificationClickListener<T> {
        public void onNotificationClicked(T var1);
    }
}

