/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.entity;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasText;
import java.util.ArrayList;
import java.util.List;

public class DefaultBadgeHolder {
    private int count;
    private List<BadgeListener> listeners = new ArrayList<BadgeListener>();
    private List<HasText> badgeHolderComponents = new ArrayList<HasText>();

    public DefaultBadgeHolder() {
    }

    public DefaultBadgeHolder(int count) {
        this.count = count;
    }

    public void increase() {
        ++this.count;
        this.listeners.forEach(listener -> listener.onChange(this));
        this.updateBadgeCaptions();
    }

    public void decrease() {
        if (this.count > 0) {
            --this.count;
        }
        this.listeners.forEach(listener -> listener.onChange(this));
        this.updateBadgeCaptions();
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
        this.listeners.forEach(listener -> listener.onChange(this));
        this.updateBadgeCaptions();
    }

    public void clearCount() {
        this.setCount(0);
    }

    public void addListener(BadgeListener listener) {
        this.listeners.add(listener);
    }

    public void bind(HasText text) {
        this.addBadgeHolderComponent(text);
    }

    private void addBadgeHolderComponent(HasText text) {
        this.badgeHolderComponents.add(text);
        this.updateBadgeCaption(text);
    }

    private void updateBadgeCaptions() {
        this.badgeHolderComponents.forEach(this::updateBadgeCaption);
    }

    private void updateBadgeCaption(HasText hasText) {
        if (hasText != null) {
            hasText.setText(String.valueOf(this.getCount()));
            if (hasText instanceof Component) {
                ((Component)hasText).setVisible(this.getCount() > 0);
            }
        }
    }

    public static interface BadgeListener {
        public void onChange(DefaultBadgeHolder var1);
    }
}

