/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.component.menu.top.item;

import com.github.appreciated.app.layout.builder.interfaces.NavigationElement;
import com.github.appreciated.app.layout.builder.interfaces.NavigationElementContainer;
import com.github.appreciated.app.layout.router.navigation.UpNavigationHelper;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.html.Label;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HighlightCondition;
import com.vaadin.flow.router.RouterLink;
import java.io.Serializable;

public class TopNavigationLink
extends RouterLink
implements NavigationElement,
BeforeEnterObserver {
    private Class<? extends Component> className;
    private NavigationElementContainer parent;

    public TopNavigationLink(String caption, Icon icon, Class<? extends Component> className) {
        this.className = className;
        HorizontalLayout wrapper = new HorizontalLayout();
        if (icon != null) {
            wrapper.add(new Component[]{icon});
        }
        if (caption != null) {
            wrapper.add(new Component[]{new Label(caption)});
        }
        wrapper.setAlignItems(FlexComponent.Alignment.CENTER);
        wrapper.setHeight("100%");
        this.add(new Component[]{wrapper});
        UpNavigationHelper.registerNavigationRoute(className);
        this.setRoute(UI.getCurrent().getRouter(), className);
        this.setHighlightCondition((HighlightCondition & Serializable)(routerLink, event) -> UpNavigationHelper.shouldHighlight(className, event.getLocation()));
    }

    public void beforeEnter(BeforeEnterEvent event) {
        if (this.parent != null) {
            this.parent.setActiveNavigationElement(UpNavigationHelper.shouldHighlight(this.className, event.getLocation()) ? this : null);
        }
    }

    @Override
    public void setNavigationElementContainer(NavigationElementContainer parent) {
        this.parent = parent;
    }
}

