/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.component.menu.left.builder;

import com.github.appreciated.app.layout.component.menu.left.LeftMenuComponentWrapper;
import com.github.appreciated.app.layout.component.menu.left.items.LeftNavigationItem;
import com.github.appreciated.app.layout.entity.Section;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.util.ArrayList;
import java.util.List;

public class LeftAppMenuBuilder {
    private final List<Component> components = new ArrayList<Component>();
    private final List<Component> header = new ArrayList<Component>();
    private final List<Component> body = new ArrayList<Component>();
    private final List<Component> footer = new ArrayList<Component>();
    private boolean sticky;

    private LeftAppMenuBuilder() {
    }

    public static LeftAppMenuBuilder get() {
        return new LeftAppMenuBuilder();
    }

    public LeftAppMenuBuilder add(Component element) {
        return this.addToSection(element, Section.DEFAULT);
    }

    public LeftAppMenuBuilder add(String caption, VaadinIcon icon, Class<? extends Component> className) {
        return this.add((Component)new LeftNavigationItem(caption, icon, className));
    }

    public LeftAppMenuBuilder add(String caption, Icon icon, Class<? extends Component> className) {
        return this.add((Component)new LeftNavigationItem(caption, icon, className));
    }

    public LeftAppMenuBuilder addToSection(Component element, Section section) {
        switch (section) {
            case HEADER: {
                this.header.add(element);
                break;
            }
            case FOOTER: {
                this.footer.add(element);
                break;
            }
            default: {
                this.body.add(element);
            }
        }
        return this;
    }

    public LeftAppMenuBuilder withStickyFooter() {
        this.sticky = true;
        return this;
    }

    public Component build() {
        this.components.addAll(this.header);
        LeftMenuComponentWrapper menu = new LeftMenuComponentWrapper();
        this.components.addAll(this.body);
        if (this.sticky) {
            menu.getMenu().getStyle().set("display", "flex");
            Div div = new Div();
            div.setWidth("100%");
            div.setHeight("0px");
            div.getStyle().set("flex", "1 1");
            this.components.add((Component)div);
        }
        this.components.addAll(this.footer);
        menu.add(this.components.toArray(new Component[0]));
        return menu;
    }
}

