/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.component.menu.left;

import com.github.appreciated.IronCollapseLayout;
import com.github.appreciated.app.layout.builder.interfaces.NavigationElement;
import com.github.appreciated.app.layout.builder.interfaces.NavigationElementContainer;
import com.github.appreciated.app.layout.component.menu.left.LeftSubmenuContainer;
import com.github.appreciated.app.layout.component.menu.left.items.LeftIconItem;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.IronIcon;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.BeforeLeaveObserver;
import com.vaadin.flow.router.HighlightAction;
import com.vaadin.flow.router.HighlightCondition;
import java.io.Serializable;
import java.util.List;

public class LeftSubmenu
extends Composite<IronCollapseLayout>
implements NavigationElementContainer,
AfterNavigationObserver,
BeforeLeaveObserver {
    private final LeftSubmenuContainer submenuContainer = new LeftSubmenuContainer();
    private final Div toggleWrapper;
    private final LeftIconItem item;
    private final IronIcon ironIcon;
    private final String caption;
    private final Icon icon;
    private NavigationElementContainer parent;
    private NavigationElement active;
    private boolean close = true;

    public LeftSubmenu(String caption, Icon icon, List<Component> submenuElements) {
        this.submenuContainer.getStyle().set("border-radius", "var(--app-layout-menu-button-border-radius)").set("background", "var(--app-layout-drawer-submenu-background-color)");
        this.getSubmenuContainer().add(submenuElements.toArray(new Component[0]));
        this.applyParentToItems(submenuElements.stream());
        this.toggleWrapper = new Div();
        this.toggleWrapper.getStyle().set("position", "relative");
        this.item = new LeftIconItem(caption, icon);
        this.item.setHighlightCondition((HighlightCondition & Serializable)(routerLink, event) -> false);
        this.item.setHighlightAction((HighlightAction & Serializable)(routerLink, highlight) -> {});
        this.ironIcon = new IronIcon("icons", "expand-more");
        this.ironIcon.getElement().getStyle().set("fill", "var(--expand-icon-fill-color)").set("position", "absolute").set("right", "var(--app-layout-menu-toggle-button-padding)").set("top", "50%").set("transform", "translate(0%, -50%) rotate(0deg)").set("transition", "transform 0.3s ease").set("pointer-events", "none");
        this.toggleWrapper.add(new Component[]{this.item, this.ironIcon});
        ((IronCollapseLayout)this.getContent()).getElement().appendChild(new Element[]{this.toggleWrapper.getElement()});
        ((IronCollapseLayout)this.getContent()).addCollapsibleContent((Component)this.submenuContainer);
        ((IronCollapseLayout)this.getContent()).getElement().getStyle().set("width", "100%");
        this.caption = caption;
        this.icon = icon;
    }

    public LeftSubmenuContainer getSubmenuContainer() {
        return this.submenuContainer;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setNavigationElementContainer(NavigationElementContainer parent) {
        this.parent = parent;
    }

    @Override
    public void setActiveNavigationElement(NavigationElement active) {
        if (active != null) {
            this.active = active;
        }
        if (this.parent != null) {
            this.parent.setActiveNavigationElement(active);
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public LeftIconItem getItem() {
        return this.item;
    }

    public IronIcon getIronIcon() {
        return this.ironIcon;
    }

    public void setCloseMenuOnNavigation(boolean close) {
        this.close = close;
    }

    public LeftSubmenu withCloseMenuOnNavigation(boolean close) {
        this.close = close;
        return this;
    }

    public void afterNavigation(AfterNavigationEvent event) {
        if (this.active != null) {
            this.item.getElement().setAttribute("highlight", true);
        } else {
            this.item.getElement().removeAttribute("highlight");
            if (this.close) {
                ((IronCollapseLayout)this.getContent()).getIronCollapse().hide();
            }
        }
    }

    public void beforeLeave(BeforeLeaveEvent event) {
        this.active = null;
    }
}

