/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.component.appbar;

import com.github.appreciated.app.layout.webcomponents.paperbadge.PaperBadge;
import com.github.appreciated.app.layout.webcomponents.papericonbutton.PaperIconButton;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.icon.VaadinIcon;

public class IconBadgeButton
extends Div {
    private static int idCounter = 0;
    private final PaperIconButton button;
    private final PaperBadge badge;

    public IconBadgeButton(VaadinIcon icon) {
        this(icon, null);
    }

    public IconBadgeButton(VaadinIcon icon, ComponentEventListener<ClickEvent<PaperIconButton>> listener) {
        this.setId("menu-btn-" + idCounter++);
        this.setWidth("var(--app-layout-menu-button-height)");
        this.setHeight("var(--app-layout-menu-button-height)");
        this.button = new PaperIconButton("vaadin:" + icon.name().toLowerCase().replace('_', '-'));
        this.button.getElement().getStyle().set("width", "100%").set("height", "100%");
        this.getElement().setAttribute("id", "button" + idCounter++);
        this.badge = new PaperBadge((Component)this, "0");
        this.badge.getElement().getStyle().set("margin-top", "6px").set("margin-left", "-6px");
        this.add(new Component[]{this.button});
        this.add(new Component[]{this.badge});
        if (listener != null) {
            this.button.setClickListener(listener);
        }
    }

    public void setBadgeCaption(String caption) {
        this.badge.setText(caption);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
    }

    public PaperIconButton getButton() {
        return this.button;
    }

    public HasText getBadge() {
        return this.badge;
    }
}

