/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.builder;

import com.github.appreciated.app.layout.behaviour.AppLayout;
import com.github.appreciated.app.layout.behaviour.Behaviour;
import com.github.appreciated.app.layout.builder.ComponentBuilder;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;

public class AppLayoutBuilder
implements ComponentBuilder {
    private AppLayout instance;
    private Component titleComponent;
    private Component imageComponent;
    private boolean upNavigation;
    private boolean swipeOpen = true;

    private AppLayoutBuilder(AppLayout instance) {
        this.instance = instance;
    }

    public static AppLayoutBuilder get(Behaviour variant) {
        return new AppLayoutBuilder(variant.getInstance());
    }

    public static AppLayoutBuilder get(AppLayout variant) {
        return new AppLayoutBuilder(variant);
    }

    public AppLayoutBuilder withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setTitle(String title) {
        Span span = new Span(title);
        span.setWidth("100%");
        span.getStyle().set("margin-left", "var(--app-layout-menu-toggle-button-padding").set("white-space", "nowrap").set("overflow", "hidden").set("text-overflow", "ellipsis");
        this.setTitleComponent((Component)span);
    }

    public void setTitleComponent(Component titleComponent) {
        this.titleComponent = titleComponent;
    }

    public AppLayoutBuilder withTitle(Component component) {
        this.setTitleComponent(component);
        return this;
    }

    public AppLayout build() {
        if (this.titleComponent != null) {
            this.instance.setTitleComponent(this.titleComponent);
        }
        if (this.imageComponent != null) {
            this.instance.setIconComponent(this.imageComponent);
        }
        if (this.swipeOpen && this.instance.getDrawer() != null) {
            this.instance.getDrawer().getElement().setAttribute("swipe-open", true);
        }
        this.instance.setUpNavigationEnabled(this.upNavigation);
        this.instance.init();
        return this.instance;
    }

    public AppLayoutBuilder withAppBar(Component component) {
        this.setAppBarComponent(component);
        return this;
    }

    public void setAppBarComponent(Component component) {
        this.instance.setAppBar(component);
    }

    public AppLayoutBuilder withAppMenu(Component component) {
        this.setAppMenu(component);
        return this;
    }

    public void setAppMenu(Component component) {
        this.instance.setAppMenu(component);
    }

    public AppLayoutBuilder withIcon(String url) {
        Image image = new Image(url, "icon");
        image.setHeight("var(--app-layout-menu-button-height)");
        image.getStyle().set("margin", "var(--app-layout-space-s)");
        return this.withIconComponent((Component)image);
    }

    public AppLayoutBuilder withSwipeOpen(boolean swipeOpen) {
        this.swipeOpen = swipeOpen;
        return this;
    }

    public AppLayoutBuilder withIconComponent(Component image) {
        this.imageComponent = image;
        return this;
    }

    public AppLayoutBuilder withUpNavigation() {
        this.upNavigation = true;
        return this;
    }
}

