/*
 * Decompiled with CFR 0.152.
 */
package com.github.appreciated.app.layout.behaviour;

import com.github.appreciated.app.layout.behaviour.AppLayout;
import com.github.appreciated.app.layout.webcomponents.applayout.AppDrawer;
import com.github.appreciated.app.layout.webcomponents.papericonbutton.PaperIconButton;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.polymertemplate.Id;
import com.vaadin.flow.dom.Element;
import java.util.Arrays;

public abstract class AbstractLeftAppLayoutBase
extends AppLayout {
    private final FlexLayout appBarElementWrapper = new FlexLayout();
    private final FlexLayout appBarElementContainer = new FlexLayout();
    private final FlexLayout titleWrapper = new FlexLayout();
    private final Div menuElements;
    private final Div contentHolder;
    @Id(value="content")
    Div contentWrapper;
    @Id(value="toggle")
    private PaperIconButton paperIconButton;
    @Id(value="app-bar-elements")
    private Div appBarElements;
    @Id(value="drawer")
    private AppDrawer drawer;
    private Component title;
    private boolean isMenuVisible = true;
    private HasElement content;
    private Component container;
    private boolean upNavigationEnabled = false;

    AbstractLeftAppLayoutBase() {
        this.getClassNames().addAll(Arrays.asList("app-layout-behaviour-" + this.getStyleName(), "app-layout"));
        FlexLayout appBarContentHolder = new FlexLayout(new Component[]{this.titleWrapper, this.appBarElementWrapper});
        appBarContentHolder.setSizeFull();
        appBarContentHolder.getElement().setAttribute("slot", "app-bar-content");
        this.appBarElementWrapper.getStyle().set("flex", "0 1 auto");
        this.appBarElementWrapper.add(new Component[]{this.appBarElementContainer});
        this.appBarElementWrapper.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        this.appBarElementWrapper.getStyle().set("flex-direction", "var(--app-layout-app-bar-flex-direction)");
        this.appBarElementContainer.getStyle().set("flex-direction", "var(--app-layout-app-bar-flex-direction)");
        this.titleWrapper.getStyle().set("flex-direction", "var(--app-layout-app-bar-flex-direction)");
        this.menuElements = new Div();
        this.menuElements.setHeight("100%");
        this.menuElements.getElement().setAttribute("slot", "drawer-content");
        this.contentHolder = new Div();
        this.contentHolder.setHeight("100%");
        this.contentHolder.setWidth("100%");
        this.contentHolder.getElement().setAttribute("slot", "application-content");
        this.titleWrapper.setHeight("100%");
        this.titleWrapper.setAlignItems(FlexComponent.Alignment.CENTER);
        this.titleWrapper.getElement().getStyle().set("flex", "1 1").set("overflow", "hidden");
        this.getElement().getClassList().add((Object)"app-layout");
        this.getElement().appendChild(new Element[]{appBarContentHolder.getElement(), this.menuElements.getElement(), this.contentHolder.getElement()});
    }

    @Override
    public abstract String getStyleName();

    @Override
    public AppDrawer getDrawer() {
        return this.drawer;
    }

    public FlexLayout getAppBarElementWrapper() {
        return this.appBarElementWrapper;
    }

    public Component getTitleLabel() {
        return this.title;
    }

    @Override
    public void setIconComponent(Component appBarIconComponent) {
        this.titleWrapper.getElement().insertChild(0, new Element[]{appBarIconComponent.getElement()});
        this.titleWrapper.setAlignItems(FlexComponent.Alignment.CENTER);
    }

    @Override
    public void setAppLayoutContent(HasElement content) {
        this.contentHolder.getElement().removeAllChildren();
        if (content != null) {
            this.contentHolder.getElement().appendChild(new Element[]{content.getElement()});
            this.content = content;
        }
    }

    @Override
    public void setAppBar(Component component) {
        this.appBarElementContainer.removeAll();
        this.appBarElementContainer.add(new Component[]{component});
    }

    @Override
    public void setAppMenu(Component container) {
        this.container = container;
        this.menuElements.removeAll();
        this.menuElements.add(new Component[]{container});
    }

    @Override
    public Component getTitleComponent() {
        return this.title;
    }

    @Override
    public void setTitleComponent(Component component) {
        this.titleWrapper.replace(this.title, component);
        this.title = component;
        this.title.getElement().getStyle().set("display", "var(--app-layout-app-bar-large-object-display)");
        this.titleWrapper.setAlignItems(FlexComponent.Alignment.CENTER);
    }

    @Override
    public FlexLayout getTitleWrapper() {
        return this.titleWrapper;
    }

    @Override
    public boolean isUpNavigationEnabled() {
        return this.upNavigationEnabled;
    }

    @Override
    public void setUpNavigationEnabled(boolean enable) {
        this.upNavigationEnabled = enable;
    }

    @Override
    public void showUpNavigation(boolean visible) {
        this.paperIconButton.setIcon(visible ? "arrow-back" : "menu");
    }

    @Override
    public HasElement getContentElement() {
        return this.content;
    }

    @Override
    public void init() {
        if (this.container == null) {
            this.setMenuVisible(false);
        }
    }

    public boolean isMenuVisible() {
        return this.isMenuVisible;
    }

    public void setMenuVisible(boolean isMenuVisible) {
        if (isMenuVisible != this.isMenuVisible) {
            this.isMenuVisible = isMenuVisible;
            if (isMenuVisible) {
                if (this.menuElements.getChildren().count() == 0L && this.container != null) {
                    this.menuElements.add(new Component[]{this.container});
                }
                this.drawer.getElement().getStyle().remove("display");
                this.paperIconButton.getElement().getStyle().remove("display");
                this.getElement().getStyle().remove("--app-layout-drawer-width");
                this.getElement().getStyle().remove("--app-layout-drawer-small-width");
            } else {
                this.drawer.getElement().getStyle().set("display", "none");
                this.menuElements.removeAll();
                this.paperIconButton.getElement().getStyle().set("display", "none");
                this.getElement().getStyle().set("--app-layout-drawer-width", "0px");
                this.getElement().getStyle().set("--app-layout-drawer-small-width", "0px");
            }
        }
    }

    @Override
    public void setPercentageHeight(boolean set) {
        if (set) {
            this.contentWrapper.getStyle().set("height", "100vh");
        } else {
            this.contentWrapper.getStyle().remove("height");
        }
    }
}

